#include <omnetpp.h>
#include <fstream.h>
#include <iomanip>
#include "mod_application.h"
#include "mediapacket_n.h"

#define n_max_attempt 3
#define TIME_SLOT 0.001 

Define_Module( Mod_Application );


void Mod_Application::initialize()
{
	input_file  = par("input_file");
	input_file.setStringValue( input_file );
        
	TYPE_VIDEO = par("type_video");

	seq_number = 0;
	seq_number_counter = 1;
	output_file = par("output_file");
        output_file.setStringValue( output_file );
	
	ev.printf("Input file is: %s\n", input_file.stringValue());
        ev.printf("Output file is: %s\n", output_file.stringValue());
	attempt = 0;
	from_low_level = gate ("from_low_level") -> id();
	to_low_level = gate("to_low_level") -> id();
	phost = parentModule();
        fstream infile;
	fstream outfile;
	char* stringa;
        infile.open(input_file.stringValue(),ios::in);
        if (infile.bad())
        {
            ev.printf("Error while opening input file (File not found or incorrect type)\n");
        }
	
	outfile.open(output_file.stringValue(), ios::out);
	if (outfile.bad())
	{
            ev.printf("Error while opening output file (File not found or incorrect type)\n"); 
	}
	
	char dummy_disp_str[21] = "";
	sprintf(dummy_disp_str, "p=%d,%d;b=16,16;i=h26lpda",200*(this->id())-300,80);
	this -> setDisplayString(dummy_disp_str,0); 
	Media *media_msg = new Media("START_TX");
        media_msg -> setKind(START_TX);
        scheduleAt( simTime() + TIME_SLOT, new Media (*media_msg));
}

void Mod_Application::handleMessage (cMessage *msg)
{	
	int seq_number;
	char c, frame_type;
	double time, YPSNR, UPSNR, VPSNR;
	int length;
	char* stringa;
	
	if (msg -> arrivalGateId() == from_low_level )
	{
		HandleFromLowLevel((Media *)msg);
		return;
	}
	
	switch (msg -> kind())
	{
		case START_TX:
		{
			infile.open(input_file.stringValue(),ios::in);
			if (infile.bad())
			{
	 			return;
			}
			else
			{
	                        Media *media_start = new Media("START_TX_MULTIMEDIA");
		                media_start -> setKind(START_TX_MULTIMEDIA);
		                send(media_start, to_low_level);		
				
				switch (TYPE_VIDEO)
				{ 
					case 0:
					{		
					   infile >> seq_number >> frame_type >> time >> length;
					   if ((frame_type == 'I')||(frame_type == 'P')||(frame_type == 'B'))
					   {
						ev.printf("MULTIMEDIA %d %c %f %d\n", seq_number, frame_type, time, length);			
						Media *media_data = new Media("MULTIMEDIA");
                        			media_data -> setKind(MULTIMEDIA);
                                		media_data -> setSeq_num(seq_number);
				        	media_data -> setFrame_type(frame_type);
						media_data -> setTime(time);
						media_data -> setLength(length);
						media_data -> setTYPE_VIDEO(TYPE_VIDEO);
						send(new Media (*media_data), to_low_level);
						scheduleAt( simTime() + TIME_SLOT, media_data);	
					   }
					   else 
					   {
						Media *media_data = new Media("MULTIMEDIA");
                                        	media_data -> setKind(MULTIMEDIA);
                                        	scheduleAt( simTime() + TIME_SLOT, media_data);
				           }
					   break;
					}
					case 1:
					{
					   infile >> seq_number >> time >> frame_type >> length >> YPSNR >> UPSNR >> VPSNR;
					   if ((frame_type == 'I')||(frame_type == 'P')||(frame_type == 'B'))
                                           {
                                                ev.printf("MULTIMEDIA %d %f %c %d %f %f %f \n", seq_number, time, frame_type, length, YPSNR, UPSNR, VPSNR);
                                                Media *media_data = new Media("MULTIMEDIA");
                                                media_data -> setKind(MULTIMEDIA);
                                                media_data -> setSeq_num(seq_number);
                                                media_data -> setFrame_type(frame_type);
                                                media_data -> setTime(time);
                                                media_data -> setLength(length);
		                                media_data -> setYPSNR(YPSNR);
			                        media_data -> setUPSNR(UPSNR);
			                        media_data -> setVPSNR(VPSNR);
						media_data -> setTYPE_VIDEO(TYPE_VIDEO); 
                                                send(new Media (*media_data), to_low_level);
                                                scheduleAt( simTime() + TIME_SLOT, media_data);
                                           }
                                           else
                                           {
                                                Media *media_data = new Media("MULTIMEDIA");
                                                media_data -> setKind(MULTIMEDIA);
                                                scheduleAt( simTime() + TIME_SLOT, media_data);
                                           }
                                           break;
                                       }
                                       case 2:
				       {
				           infile >> seq_number >> time >> frame_type >> length >> YPSNR >> UPSNR >> VPSNR;
				           if (seq_number == seq_number_counter)
				           {
				                ev.printf("MULTIMEDIA %d %f %f %f \n", seq_number, YPSNR, UPSNR, VPSNR);
				                Media *media_data = new Media("MULTIMEDIA");
				                media_data -> setKind(MULTIMEDIA);
				                media_data -> setSeq_num(seq_number);
                                                media_data -> setYPSNR(YPSNR);
                                                media_data -> setUPSNR(UPSNR);
                                                media_data -> setVPSNR(VPSNR);
                                                media_data -> setTYPE_VIDEO(TYPE_VIDEO);
                                                send(new Media (*media_data), to_low_level);
						seq_number++;
                                                scheduleAt( simTime() + TIME_SLOT, media_data);
                                           }
                                           else
                                           {
	                                        Media *media_data = new Media("MULTIMEDIA");
	                                        media_data -> setKind(MULTIMEDIA);
                                                scheduleAt( simTime() + TIME_SLOT, media_data);
                                           }
                                           break;
                                       }
				}
			}
		break;
		}
		case  MULTIMEDIA:
		{	
			// infile >> seq_number >> frame_type >> time >> length;
			// infile >> seq_number >> time >> frame_type >> length >> YPSNR >> UPSNR >> VPSNR;

                        switch (TYPE_VIDEO)
                        {
	                        case 0:
	                        {
                                      infile >> seq_number >> frame_type >> time >> length;
                                      if ((frame_type == 'I')||(frame_type == 'P')||(frame_type == 'B'))
                                      {
                                           ev.printf("MULTIMEDIA %d %c %f %d\n", seq_number, frame_type, time, length);
                                           Media *media_data = new Media("MULTIMEDIA");
                                           media_data -> setKind(MULTIMEDIA);
                                           media_data -> setSeq_num(seq_number);
                                           media_data -> setFrame_type(frame_type);
                                           media_data -> setTime(time);
                                           media_data -> setLength(length);
					   media_data -> setTYPE_VIDEO(TYPE_VIDEO);
                                           send(new Media (*media_data), to_low_level);
                                           scheduleAt( simTime() + TIME_SLOT, media_data);
                                      }
                                      else if ((attempt < n_max_attempt) && (!infile.eof()))
                                      	   {
						   while ((c!='\n')) // read line header until end of line
					           {
						      if (infile.fail())
						      {
						           infile.clear();
						      }
						      infile.get(c);
						   }
						   ev.printf("MULTIMEDIA check attempt %d\n", attempt);
						   Media *media_data = new Media("MULTIMEDIA");
						   media_data -> setKind(MULTIMEDIA);
						   scheduleAt (simTime() + TIME_SLOT, media_data);
						   attempt++;
					   }
				           else
					   {	
						TYPE_VIDEO++;
						infile.close();
						infile.open(input_file.stringValue(),ios::in);
						infile.seekg(0,ios::beg);
						attempt=0;
						Media *media_data = new Media("MULTIMEDIA");
						media_data -> setKind(MULTIMEDIA);
						scheduleAt (simTime() + TIME_SLOT, media_data);
					   }
                                      break;
                                }
                                case 1:
                                {
				      
                                      infile >> seq_number >> time >> frame_type >> length >> YPSNR >> UPSNR >> VPSNR;
                                      if ((frame_type == 'I')||(frame_type == 'P')||(frame_type == 'B'))
                                      {
                                           ev.printf("MULTIMEDIA %d %f %c %d %f %f %f \n", seq_number, time, frame_type, length, YPSNR, UPSNR, VPSNR);
                                           Media *media_data = new Media("MULTIMEDIA");
                                           media_data -> setKind(MULTIMEDIA);
                                           media_data -> setSeq_num(seq_number);
                                           media_data -> setFrame_type(frame_type);
                                           media_data -> setTime(time);
                                           media_data -> setLength(length);
                                           media_data -> setYPSNR(YPSNR);
                                           media_data -> setUPSNR(UPSNR);
                                           media_data -> setVPSNR(VPSNR);
					   media_data -> setTYPE_VIDEO(TYPE_VIDEO);
                                           send(new Media (*media_data), to_low_level);
                                           scheduleAt( simTime() + TIME_SLOT, media_data);
                                      }
                                      else if  ((attempt < n_max_attempt) && (!infile.eof()))      
                                      	   {
                                                   while ((c!='\n')) // read line header until end of line
                                                   {
                                                      if (infile.fail())
                                                      {
                                                           infile.clear();
                                                      }
                                                      infile.get(c);
                                                   }
                                                   ev.printf("MULTIMEDIA check attempt %d\n", attempt);
                                                   Media *media_data = new Media("MULTIMEDIA");
                                                   media_data -> setKind(MULTIMEDIA);
                                                   scheduleAt (simTime() + TIME_SLOT, media_data);
                                                   attempt++;
                                           }
				      	   else
					   {
						   TYPE_VIDEO++;
                                                   infile.close();
                                                   infile.open(input_file.stringValue(),ios::in);
                                                   infile.seekg(0,ios::beg);
						   attempt = 0;
						   Media *media_data = new Media("MULTIMEDIA");
						   media_data -> setKind(MULTIMEDIA);
						   scheduleAt(simTime() + TIME_SLOT, media_data);
			                   }
                                      break;
                                }
                                case 2:
                                {
	                                infile >> seq_number >> YPSNR >> UPSNR >> VPSNR;
	                                if (seq_number == seq_number_counter)
	                                {
	                                     ev.printf("MULTIMEDIA %d %f %f %f \n", seq_number, YPSNR, UPSNR, VPSNR);
	                                     Media *media_data = new Media("MULTIMEDIA");
	                                     media_data -> setKind(MULTIMEDIA);
                                             media_data -> setSeq_num(seq_number);
//                                             media_data -> setFrame_type(frame_type);
//                                             media_data -> setTime(time);
//                                             media_data -> setLength(length);
                                             media_data -> setYPSNR(YPSNR);
                                             media_data -> setUPSNR(UPSNR);
                                             media_data -> setVPSNR(VPSNR);
                                             media_data -> setTYPE_VIDEO(TYPE_VIDEO);
                                             send(new Media (*media_data), to_low_level);
					     seq_number_counter++;
                                             scheduleAt( simTime() + TIME_SLOT, media_data);
                                        }
                                        else if  ((attempt < n_max_attempt) && (!infile.eof()))
                                        {
                                             while ((c!='\n')) // read line header until end of line
                                             {
	                                             if (infile.fail())
	                                             {
	                                                 infile.clear();
	                                             }
	                                             infile.get(c);
                                             }
                                             ev.printf("MULTIMEDIA check attempt %d\n", attempt);
                                             Media *media_data = new Media("MULTIMEDIA");
                                             media_data -> setKind(MULTIMEDIA);
                                             scheduleAt (simTime() + TIME_SLOT, media_data);
                                             attempt++;
                                        }
                                        else
                                        {
                                             TYPE_VIDEO++;
                                             attempt = 0;
                                             Media *media_data = new Media("MULTIMEDIA");
                                             media_data -> setKind(MULTIMEDIA);
                                             scheduleAt(simTime() + TIME_SLOT, media_data);
                                        }
                                   break;
                                }
				case 3:
				{
				      ev.printf("Not a valid format or end of file\n");
                                      Media *msg_finish = new Media("END_TX_MULTIMEDIA");
                                      msg_finish -> setKind(END_TX_MULTIMEDIA);
                                      send(msg_finish, to_low_level);
				      infile.close();
				}
                        }	
		}
		break;
	}
}
	

void Mod_Application::HandleFromLowLevel(Media *msg)
{
	char c;
        int seq_number;
        char frame_type;
        double time;
        int length;
	
	switch (msg -> kind())
	{
		case START_TX_MULTIMEDIA:
		{
			outfile.open(output_file.stringValue(), ios::out);
		}
		break;
		
		case MULTIMEDIA:
		{
	 		switch (msg->getTYPE_VIDEO())
			{
			   case 0:
				   {
					if ((msg -> getSeq_num()) !=0)
					{
					   outfile << msg -> getSeq_num() << "		"<< msg-> getFrame_type()  
		   	                           << "		" << msg->getTime() <<"		" << msg->getLength() << endl;
					}
					else
					{
                                           if (outfile.bad())
                                           {
                                                ev.printf("Error while opening output file type 0\n");
                                                return;
                                           }
                                           outfile << "Frame No.   Frametype       Time [ms]       Length [byte] \n"; // FIX ME!!!
                                           outfile << "-------------------------------------------------------------------------------------------------------\n"; // FIX ME!!!i
					   outfile << msg -> getSeq_num() << "		"<< msg-> getFrame_type()
                                                   << "		" << msg->getTime() <<"		" << msg->getLength() << endl;
					}
				   }
				   break;
			   case 1:
				   {
					   if (outfile.bad())
                                           {
                                                ev.printf("Error while opening output file type 1\n");
                                            	return;
                                           }
					   outfile << msg -> getSeq_num()<< "		"<<setfill (' ')<<setw(10) << msg->getTime() 
						   << "		" << msg-> getFrame_type() <<"		" << setfill (' ')<<setw(6) << msg->getLength()
                                                   << "		" << msg -> getYPSNR()<< "		"<< msg -> getUPSNR()<<"		"<< msg -> getVPSNR() << endl;
					
				    }
				    break;
			   case 2:
				    {
				           if ((msg -> getSeq_num()) !=1)
				           {
                                                outfile << msg -> getSeq_num() << "		"<< msg-> getYPSNR()
                                                        << "	" << msg->getUPSNR() <<"	" << msg->getVPSNR() << endl;
                                           }
                                           else
                                           {
                                              if (outfile.bad())
                                              {
                                                   ev.printf("Error while opening output file type 0\n");
			                           return;
			                      }
			                      outfile << "Frame No.	PSNR	UPSNR	VPSNR \n"; // FIX ME!!!
			                      outfile << "-------------------------------------------------------------------------------------------------------\n"; // FIX ME!!!i
			                      outfile << msg -> getSeq_num() << "		"<< msg->getYPSNR() << "	" << msg->getUPSNR() << "	" 
						      << msg ->getVPSNR() << endl;
                                           }
                                     }
				     break;
				   
			}
		}
		break;
		
		case END_TX_MULTIMEDIA:
		{
			outfile.close();
		}
		break;

	}
	delete msg;
}
