static const char file_id[] = "DEVideo.pl";
// .cc file generated from DEVideo.pl by ptlang
/*
 * copyright (c) Telecommunication Networks TKN : Technical University Berlin
 */

#ifdef __GNUG__
#pragma implementation
#endif

#include "DEVideo.h"
#include <ACG.h>
#include <Uniform.h>

const char *star_nm_DEVideo = "DEVideo";

const char* DEVideo :: className() const {return star_nm_DEVideo;}

ISA_FUNC(DEVideo,DERepeatStar);

Block* DEVideo :: makeNew() const { LOG_NEW; return new DEVideo;}

# line 271 "DEVideo.pl"
extern ACG* gen;

DEVideo::DEVideo ()
{
	setDescriptor("Generate events similar to H263 Encoder, starting at time zero.");
	addPort(output.setPort("output",this,FLOAT));
	addState(CodingType.setState("CodingType",this,"H263","MPEG4 and H263x is supported"));
	addState(TraceList.setState("TraceList",this,"H263TraceList.dat","file name were trace files are specified"));
	addState(InputDir.setState("InputDir",this,"$TRACE_PT_DIR/","location of trace files and this->TraceList"));
	addState(framescale.setState("framescale",this,"1.0","scaling the frame size"));
	addState(Offset.setState("Offset",this,"0.0","uniform random phase for sequence start"));
	addState(maxFrameSize.setState("maxFrameSize",this,"1000.0","larger frames will be skipped"));
	addState(Duration.setState("Duration",this,"1000.0","uniform random trace duration in sec"));
	addState(DEBUG.setState("DEBUG",this,"3","different DEBUG level for stdout"));

# line 274 "DEVideo.pl"
randomuni = 0;
		    randomuni2 = 0;
}

void DEVideo::wrapup() {
# line 332 "DEVideo.pl"
}

DEVideo::~DEVideo() {
# line 278 "DEVideo.pl"
LOG_DEL; delete randomuni;
		    LOG_DEL; delete randomuni2;
}

void DEVideo::setup() {
# line 282 "DEVideo.pl"
if (Duration > 3580) Duration=3580; //no longer trace lists
			if (Duration <= Offset) {
			  Error::abortRun(*this, "Duration smaller than Offset is not allowed!");
			}
                    LOG_DEL; delete randomuni;
                    double mOru = double(Offset);// mean or upper
                    LOG_NEW; randomuni = new Uniform(1.0, mOru, gen);

		    LOG_DEL; delete randomuni2;
                    mOru = double(Duration);// mean or upper
                    LOG_NEW; randomuni2 = new Uniform(1.0, mOru, gen);

		    framesperflow=0;
		    capperflow=0;
		    endTime=-1;

		    start=TRUE;
}

void DEVideo::go() {
# line 302 "DEVideo.pl"
if (start) {
			getstarted();
			newflow();
		    }
		    if (list[counter+1].playout>=0 && list[counter].playout>=0 ) {
			float outvalue = list[counter].size;
			if (outvalue > 0 && outvalue <= maxFrameSize) {
			    output.put(completionTime) << outvalue;
			}
			else {
			    cout << "\tskipped frame with value" << outvalue << endl;
			    start=TRUE;
			    //completionTime += 0.04;
			}
			if ((list[counter+1].playout-list[counter].playout>0)) {
			    completionTime += list[counter+1].playout-list[counter].playout;
			}
		    }
		    else {
			start=TRUE;
			//completionTime += 0.04;
		    }
		    counter++;
		    if (counter>89998*timescale) {
			start=TRUE;
			Error::warn(*this, "CounterValue too high");
		    }
		    refireAtTime(completionTime);
}


float DEVideo::getflowendtime ()
{
# line 112 "DEVideo.pl"
startdelay=int(uniformvaluerandom);
			flowendtime =0;
			flowendtime = int((*randomuni2)()*timescale)+startdelay;
			if (flowendtime>(3580*timescale)) flowendtime=3580*timescale;
			return flowendtime;
}


float DEVideo::getstarted ()
{
# line 125 "DEVideo.pl"
startTime=completionTime;
			//endTime=completionTime+1000;
			start=FALSE;
			counter=0;
			framesperflow=0;
			capperflow=0;
			struct listentry tmp;
			tmp.size=-1;
			tmp.playout=-1;
			for (int i=0; i<90000; i++) list[i]=tmp;
			//tmp.size=800;
			//tmp.playout+=1;
			//for (int i=0; i<1000; i++) list[i]=tmp;
			return 0;
}


int DEVideo::newflow ()
{
# line 147 "DEVideo.pl"
uniformvaluerandom = (*randomuni)();
			strcpy(tracelist,"");
			strcat(tracelist,(const char*)InputDir);
			strcat(tracelist,(const char*)TraceList);
			infile=fopen((const char*)tracelist, "r");
			if (!infile) {
			  Error::warn(*this, "Couldn't open input-file ",(const char*)tracelist);
			}
			else {
			    if (DEBUG) cout << arrivalTime << ":\tOpen TraceFileList " << TraceList << endl;
			    for(numberoftraces=0;!feof(infile);numberoftraces++) {
				fscanf(infile,"%s %f",&string, &timescale);
				if (DEBUG>3) cout << "  " << numberoftraces << " Trace File Name " << string << endl;
				if (numberoftraces>1000) {
				    Error::warn(*this, "Contains more than 1000 entries!",(const char*)tracelist);
				} 
			    }                       
			    fclose(infile);
			    int tracerandomnumber=(uniformvaluerandom % numberoftraces)+1;
			    if (tracerandomnumber<1 || tracerandomnumber > 25) {
				Error::warn(*this, "Counter of movies is too high!");
				tracerandomnumber=1;
			    }
			    infile=fopen((const char*)tracelist, "r");
			    if (!infile) {
			      Error::warn(*this, "Couldn't open input-file ",(const char*)tracelist);
			    }
			    else {
				if (DEBUG>3) cout << "Open File " << TraceList << " Read Data " << tracerandomnumber << " of " << numberoftraces << endl;
				for (int i=1; i <= tracerandomnumber; i++) {
				    fscanf(infile,"%s %f",&string, &timescale);
				    if (DEBUG>3) cout << "\t" << numberoftraces << " Trace File Name " << string << endl;
				}    
				if (DEBUG) cout << arrivalTime << ":\tTrace File Name:\t" << string << "(" << tracerandomnumber << "/" << numberoftraces << ")" << endl;
				if (DEBUG>2) cout << "\tFrame Scaling Factor:\t" << framescale << endl;
				if (DEBUG>2) cout << "\tTime Scaling Factor:\t" << timescale << endl;
				fclose(infile);
			    }
			    strcpy(tracefile,"");
			    strcat(tracefile,(const char*)InputDir);
			    strcat(tracefile,(const char*)string);
			    infile=fopen((const char*)tracefile, "r");

			    startTime=arrivalTime;
			    endTime=arrivalTime+getflowendtime();
			    if (DEBUG>2) cout << "\tStart Delay:\t\t" << startdelay << " sec " << endl; 
			    if (DEBUG>2) cout << "\tFlow End:\t\t" << flowendtime << " sec " << endl; 
			    if (!infile) {
			      Error::warn(*this, "Couldn't open input-file ",(const char*)tracefile);
			    }
			    else {
				if (!strcmp(CodingType,"H263")) {
				    frametime=0;
				    int skippedframes=0;
				    while (frametime/1000 < startdelay && frametime<3580000*timescale) {
					fscanf(infile,"%d %s %d",&frametime, &frametype, &framesize);
					if (DEBUG>3) cout << ".";
					skippedframes++;
				    }
				    if (DEBUG>2) cout << "\tSkipped H263 Frames:\t\t" << skippedframes << endl; 
				    framesperflow=0;
				    while (frametime/1000 <= flowendtime && frametime<3580000*timescale) {
					fscanf(infile,"%d %s %d",&frametime, &frametype, &framesize);
					if (DEBUG>9) cout <<frametime<<":"<<frametype<<":"<<framesize<<endl;
					if (framesperflow>=0 && framesperflow<90000) {
					    list[framesperflow].size=ceil(framesize*framescale);
					    list[framesperflow].playout=float(frametime)/1000.0;
					}
					framesperflow++;
					capperflow+=ceil(framesize*framescale);
					if (DEBUG>3) cout << "*";
				    }
				    if (DEBUG>3) cout << endl;
				    float bitrate = 8*capperflow/(flowendtime-startdelay);
				    if (DEBUG>2) cout << "\tFrames per Flow:\t" << framesperflow << endl;
				    if (DEBUG>2) cout << "\tCapacity:\t\t" << capperflow << " byte" << endl;
				    if (DEBUG>2) cout << "\tBitrate:\t\t" << bitrate << endl;
				}
				else if (!strcmp(CodingType,"MPEG4")) {
				    frametime=0;
				    int skippedframes=0;
				    int toskip=ceil(startdelay/0.04);
				    for (int i=0; i <= toskip; i++) {
					fscanf(infile,"%d",&framesize);
					if (DEBUG>3) cout << ".";
					skippedframes++;
				    }
				    if (DEBUG>2) cout << "\tSkipped MPEG4 Frames:\t\t" << skippedframes << endl; 
				    framesperflow=0;
				    int tosend=ceil((flowendtime-startdelay)/0.04);
				    if (DEBUG>2) cout << "\tSend Frames Frames:\t\t" << tosend << endl; 
				    for (int i=0; i <= tosend; i++) {
					fscanf(infile,"%d",&framesize);
					if (DEBUG>9) cout <<frametime<<":"<<frametype<<":"<<framesize<<endl;
					if (framesperflow>=0 && framesperflow<90000) {
					    list[framesperflow].size=ceil(framesize*framescale);
					    list[framesperflow].playout=framesperflow*0.04;
					}
					framesperflow++;
					capperflow+=ceil(framesize*framescale);
					if (DEBUG>3) cout << "*";
				    }
				    if (DEBUG>3) cout << endl;
				    float bitrate = 8*capperflow/(flowendtime-startdelay);
				    if (DEBUG>2) cout << "\tFrames per Flow:\t" << framesperflow << endl;
				    if (DEBUG>2) cout << "\tCapacity:\t\t" << capperflow << " byte" << endl;
				    if (DEBUG>2) cout << "\tBitrate:\t\t" << bitrate << endl;
				}
				else {
				  Error::warn(*this, "Coding Type not supported");   
				}
				fclose(infile);
			    }
			    return 0;
			}
			return 0;
}


// prototype instance for known block list
static DEVideo proto;
static RegisterBlock registerBlock(proto,"Video");
